﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="my_instruments.aspx.cs" Inherits="my_instruments" %>
<%@ MasterType VirtualPath="~/MasterPage.master" %>
<%@ Register TagPrefix="tbi" TagName="InstrumentList" Src="~/ucInstrumentList.ascx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cpHeader" runat="Server">
    <link href="css/bootstrap.cerulean.min.css" rel="stylesheet" />
    <link href="css/instruments.css" rel="stylesheet" />

    <script src="js/bootstrap-3.1.1.js"></script>
    <script src="js/jquery.maskedinput.min.js"></script>
    <script src="js/jquery.runner.js"></script>

    <script src="js/my.instruments.js"></script>

    <style>
        table.tbl-module-report {
            border-collapse: collapse;
            width: 100%;
        }

        .tbl-module-report td {
            padding: 8px;
            vertical-align: top;
            width: 50%;
            border-top: 1px solid #e6e5e5;
        }

        .tbl-module-report tr td:nth-child(2) {
            padding-left: 20px;
        }

        .tr-report-header td {
            background-color: #eee;
            font-weight: bold;
        }
    </style>

</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <ext:Panel runat="server"
        AnchorVertical="100%"
        AnchorHorizontal="100%"
        Layout="BorderLayout"
        Border="false">
        <Items>
            <ext:Panel runat="server"
                Region="North"
                Padding="5"  
                Split="false" 
                StyleSpec="background: #fff;"
                BodyStyle="background: #fff;" 
                Frame="false" 
                FrameHeader="false"
                Border="false">
                <Content>
                    <span style="font-size: 1.3em; font-weight: 500;">My Instruments</span>
                </Content>
            </ext:Panel>
            <ext:Panel runat="server"
                Region="Center"
                Border="false" 
                Layout="BorderLayout">
                <Items>
                    <ext:Panel ID="pnlAppointmentInstruments" 
                        runat="server"
                        Title="Appointment Instruments"
                        Region="West"
                        Flex="1"
                        Split="true"
                        Collapsible="true" 
                        Layout="AnchorLayout" >
                        <Content>
                            <tbi:InstrumentList ID="ucInstrumentList" runat="server" />
                        </Content>
                    </ext:Panel>
                    <ext:Panel ID="pnlInstrumentsWrkArea" 
                        runat="server"
                        Region="Center"
                        Flex="4"
                        Border="false"
                        Layout="AnchorLayout">
                        <Items>
                            <ext:TabPanel ID="tpPatInstruments"
                                runat="server"
                                Border="false"
                                AnchorHorizontal="100%"
                                AnchorVertical="100%" 
                                Layout="AnchorLayout">
                                <Items>
                                    <ext:Panel ID="pnlInstrumentFormTab" 
                                        runat="server" 
                                        Title="Instrument" 
                                        AutoDoLayout="true"
                                        AnchorHorizontal="100%"
                                        AnchorVertical="100%" 
                                        OverflowY="Auto" 
                                        Border="false">
                                        <Items>
                                            <ext:Panel ID="pnlInstrumentContainer" 
                                                runat="server" 
                                                Border="false"
                                                BodyStyle="background: #fff;"></ext:Panel>
                                            <ext:Panel ID="pnlSubmitInstrument" 
                                                runat="server" 
                                                Border="false" 
                                                Hidden="true">
                                                <Content>
                                                    <div style="text-align: center;">
                                                        <input type="button" value="I'm finished" onclick="CompanyX.direct.INSTRUMENTS.SubmitInstrumentResponses();" />
                                                        <%--<ext:Button runat="server" Text="I'm finished">
                                                            <Listeners>
                                                                <Click Fn="CompanyX.direct.INSTRUMENTS.SubmitInstrumentResponses"></Click>
                                                            </Listeners>
                                                        </ext:Button>--%>
                                                    </div>
                                                </Content>
                                            </ext:Panel>
                                        </Items>
                                    </ext:Panel>
                                    <ext:Panel ID="pnlInstrumentReportTab" 
                                        runat="server" 
                                        Title="Report" 
                                        AnchorHorizontal="100%"
                                        AnchorVertical="100%" 
                                        Layout="AnchorLayout" 
                                        AutoScroll="true" 
                                        AutoDoLayout="true" 
                                        Border="false">
                                        <Items>
                                            <ext:Panel ID="pnlInstrumentReport" 
                                                IDMode="Static" 
                                                runat="server" 
                                                AnchorHorizontal="100%"
                                                AnchorVertical="100%" 
                                                AutoScroll="true" 
                                                AutoDoLayout="true" 
                                                Border="false" 
                                                Frame="false">
                                                <%--<TopBar>
                                                    <ext:Toolbar ID="Toolbar1" runat="server">
                                                        <Items>
                                                            <ext:ToolbarFill />
                                                            <ext:Button ID="Button2" runat="server" Text="To Excel" AutoPostBack="true" OnClick="ToExcel" Icon="PageExcel" />
                                                            <ext:Button ID="Button3" runat="server" Text="To CSV" AutoPostBack="true" OnClick="ToCsv" Icon="PageAttach" />
                                                        </Items>
                                                    </ext:Toolbar>
                                                </TopBar>--%>
                                                <Tpl ID="Tpl1" runat="server">
                                                    <Html>
                                                        <tpl for".">
                                                            <div class="container-fluid">
                                                                <h4>{ModuleTitle}</h4>

                                                                <%-- Get instrument's scores --%>
                                                                <tpl if="Scores.length &gt; 0">
                                                                    <div class="panel panel-default">
                                                                        <div class="panel-heading">Score</div>
                                                                        <div class="panel-body">
                                                                            <table style="border-collapse: collapse;">
                                                                                <tr>
                                                                                    <th style="padding-right: 20px;">Description</th>
                                                                                    <th style="width: 80px; padding-right: 20px;">Score</th>
                                                                                    <th>Interpretation</th>
                                                                                </tr>
                                                                                <tpl for="Scores">
                                                                                    <tr>
                                                                                        <td style="padding-right: 20px;">{Description}</td>
                                                                                        <td style="padding-right: 20px;">{ScoreValue}</td>
                                                                                        <td>{Interpretation}</td>
                                                                                    </tr>
                                                                                </tpl>
                                                                            </table>
                                                                        </div>
                                                                    </div>
                                                                </tpl>

                                                                <tpl for="Topics">
                                                                    <div class="panel panel-default">
                                                                        <div class="panel-heading">{TopicTitle}</div>
                                                                        <div class="panel-body">
                                                                            <table class="tbl-module-report">
                                                                                <tr class="tr-report-header">
                                                                                    <td>Questions</td>
                                                                                    <td>Responses</td>
                                                                                </tr>
                                                                                <tpl for="Questions">
                                                                                    <tr>
                                                                                        <td class="td-question">
                                                                                            {QuestionTitle}
                                                                                        </td>
                                                                                        <td class="td-response">
                                                                                            <tpl for="Responses">
                                                                                                <div style="display: block; padding-bottom: 5px;">
                                                                                                    <tpl if="DisplayType == 3">
                                                                                                        <span>{StaticResponseText} {ResponseValue} {ResponseUnit}</span>
                                                                                                    <tpl elseif="DisplayType == 4">
                                                                                                        <span>{StaticResponseText} {ResponseValue}</span>
                                                                                                    <tpl else>
                                                                                                        <span>{ResponseValue}</span>
                                                                                                    </tpl>
                                                                                                </div>
                                                                                            </tpl>
                                                                                        </td>
                                                                                    </tr>
                                                                                </tpl>
                                                                            </table>
                                                                        </div>
                                                                    </div>
                                                                </tpl>
                                                            </div>
                                                        </tpl>
                                                    </Html>
                                                </Tpl>
                                            </ext:Panel>
                                        </Items>
                                    </ext:Panel>
                                    <ext:Panel ID="pnlInstrumentTrendTab" 
                                        runat="server"
                                         Title="Trend" 
                                        Border="false" 
                                        Hidden="true"></ext:Panel>
                                </Items>
                            </ext:TabPanel>
                        </Items>
                    </ext:Panel>
                </Items>
            </ext:Panel>
        </Items>
    </ext:Panel>

    <%-- hidden fields to store extra details of selected instrument --%>
    <ext:Hidden ID="htxtInstrumentData" runat="server"></ext:Hidden>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cpScripts" runat="Server">
</asp:Content>

